IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Tarjeta_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Tarjeta_Validar
END
GO

CREATE FUNCTION [dbo].[CF_Tarjeta_Validar] (@Id_Tarjeta VARCHAR(10),@Tar_Nro VARCHAR(50) )
RETURNS VARCHAR(100)	
AS

BEGIN


DECLARE @Descripcion		VARCHAR(100);
DECLARE @Flag_Valida_Long	TINYINT;
DECLARE @Valida_PimerDig	CHAR(9);
DECLARE @Flag_Valida_DV		TINYINT;


SET @Descripcion = '';

IF ISNULL(@Id_Tarjeta,'') = '' 
	RETURN @Descripcion;

SELECT @Flag_Valida_Long = Flag_Valida_Long , @Valida_PimerDig = Valida_PimerDig , @Flag_Valida_DV = Flag_Valida_DV 
	FROM Valores_Tarjetas_Cred WHERE Id_Tarjeta = @Id_Tarjeta


IF ISNULL(@Flag_Valida_Long,0) != 0
BEGIN
	IF LEN(RTRIM(LTRIM(@Tar_Nro))) <> @Flag_Valida_Long
	BEGIN
		SET @Descripcion = 'Cantidad de Digitos Invalido';
		RETURN @Descripcion;
	END
END

IF ISNULL(@Valida_PimerDig,'') != ''
BEGIN
	IF SUBSTRING(RTRIM(LTRIM(@Tar_Nro)),1,LEN(RTRIM(LTRIM(@Valida_PimerDig)))) <> SUBSTRING(RTRIM(LTRIM(@Valida_PimerDig)),1, LEN(RTRIM(LTRIM(@Valida_PimerDig))))
	BEGIN
		SET @Descripcion = 'El Nro. No Corresponde a la Tarjeta/CBU Selecionado.';
		RETURN @Descripcion;
	END
END

IF ISNULL(@Flag_Valida_DV,0) != 0
BEGIN
	IF @Flag_Valida_DV = 1
	BEGIN 
		IF ISNULL(  (SELECT dbo.SF_Tar_Validar(@Tar_Nro)) ,0 ) = 0
		BEGIN
			SET @Descripcion = 'Nro. de tarjeta invalido.';
			RETURN @Descripcion;
		END 
	END
	IF @Flag_Valida_DV = 2
	BEGIN 
		IF ISNULL(  (SELECT dbo.SF_Cbu_Validar(@Tar_Nro)) ,0 ) = 0
		BEGIN
			SET @Descripcion = 'Nro. de CBU invalido.';
			RETURN @Descripcion;
		END 
	END
END
	

RETURN @Descripcion;

END

